# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 7
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR7_strategy.txt
# LLM Suggested Fallback: C

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR7(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Initial Rounds (1-3): Cooperate to build trust
    if current_round <= 3:
        return "C"
    
    # Check opponent's behavior in initial rounds
    early_defects = opp_history[:3].count("D")
    
    # Mid Rounds (4-7)
    if 4 <= current_round <= 7:
        if early_defects > 0:
            # Tit-for-Tat: Mirror opponent's last move
            return opp_history[-1] if opp_history else "C"
        else:
            # Continue cooperating if opponent cooperated initially
            return "C"
    
    # Final Rounds (8-10)
    if current_round >= 8:
        if opp_history[-3:].count("D") > 0:
            # Defect if opponent has defected recently
            return "D"
        else:
            # Continue cooperating if mutual cooperation maintained
            return "C"
    
    # Default to cooperate if no conditions met (shouldn't happen)
    return "C"